% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sdtm_metadata}
\alias{sdtm_metadata}
\title{SDTM Variable-Level Metadata}
\format{
A tibble with 43 rows and 6 columns:
\describe{
\item{dataset}{Character. SDTM domain name (DM, AE, LB).}
\item{variable}{Character. Variable name.}
\item{label}{Character. Variable label.}
\item{type}{Character. Variable type (Char or Num).}
\item{length}{Integer. Variable length.}
\item{format}{Character. SAS (Statistical Analysis System) format (or NA).}
}
}
\source{
Synthetic metadata based on CDISC SDTM (Study Data Tabulation
Model) standards.
}
\usage{
sdtm_metadata
}
\description{
SDTM (Study Data Tabulation Model) variable-level metadata for DM
(Demographics, 17 vars), AE (Adverse Events, 14 vars), and LB
(Laboratory Results, 12 vars). Follows CDISC (Clinical Data
Interchange Standards Consortium) SDTM conventions.
}
\examples{
data(sdtm_metadata)
table(sdtm_metadata$dataset)
}
\keyword{datasets}
