% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qryflow.R
\name{qryflow}
\alias{qryflow}
\title{Run a multi-step SQL workflow and return query results}
\usage{
qryflow(con, sql, ..., simplify = TRUE)
}
\arguments{
\item{con}{A database connection from \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{sql}{A file path to a \code{.sql} workflow or a character string containing SQL code.}

\item{...}{Additional arguments passed to \code{\link[=qryflow_run]{qryflow_run()}} or \code{\link[=qryflow_results]{qryflow_results()}}.}

\item{simplify}{Logical; if \code{TRUE} (default), a list of length 1 is simplified to the
single result object.}
}
\value{
A named list of query results, or a single result if \code{simplify = TRUE} and only one chunk exists.
}
\description{
\code{qryflow()} is the main entry point to the \code{qryflow} package. It executes a SQL workflow
defined in a tagged \code{.sql} script or character string and returns query results as R objects.

The SQL script can contain multiple steps tagged with \verb{@query} or \verb{@exec}. Query results
are captured and returned as a named list, where names correspond to the \verb{@query} tags.
}
\details{
This is a wrapper around the combination of \code{\link[=qryflow_run]{qryflow_run()}}, which always provides a list of results and metadata,
and \code{\link[=qryflow_results]{qryflow_results()}}, which filters the output of \code{\link[=qryflow_run]{qryflow_run()}} to only include the results of the SQL.
}
\examples{
con <- example_db_connect(mtcars)

filepath <- example_sql_path("mtcars.sql")

results <- qryflow(con, filepath)

head(results$df_mtcars)

DBI::dbDisconnect(con)
}
\seealso{
\code{\link[=qryflow_run]{qryflow_run()}}, \code{\link[=qryflow_results]{qryflow_results()}}
}
