% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvars.R
\docType{data}
\name{MERM}
\alias{MERM}
\title{Data set for the \emph{Monetary Exchange Rate Model}}
\format{
A long-format data panel of class '\code{data.frame}', 
  where the columns \code{id_i} and \code{id_t} 
  indicate the country and month respectively.
}
\source{
The prepared data set is directly obtainable from the journal website: 
  \doi{10.1016/j.ecosta.2016.10.001}. Supplementary Raw Research Data. 
  This is open data under the \href{https://creativecommons.org/licenses/by/4.0/}{CC BY 4.0 license}.
}
\usage{
data("MERM")
}
\description{
The data set \code{MERM} consists of 
  monthly observations for the log-ratios of 
  prices \eqn{p}, money supply \eqn{m}, and industrial production \eqn{y} 
  as well as the natural logarithm of nominal exchange rates against the dollar \eqn{s}. 
  It covers the period January 1995 to December 2007 \eqn{(T=156)} for \eqn{N=19} countries.
}
\references{
Oersal, D. D. K., and Arsova, A. (2017): 
  "Meta-Analytic Panel Cointegrating Rank Tests for Dependent Panels", 
  \emph{Econometrics and Statistics}, 2, pp. 61-72.
}
\seealso{
Other data sets: 
\code{\link{ERPT}},
\code{\link{EURO}},
\code{\link{EU_w}},
\code{\link{ICAP}},
\code{\link{MDEM}},
\code{\link{PCAP}},
\code{\link{PCIT}}
}
\concept{data sets}
\keyword{datasets}
