% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvars.R
\docType{data}
\name{MDEM}
\alias{MDEM}
\title{Data set for the \emph{Monetary Demand Model}}
\format{
A long-format data panel of class '\code{data.frame}', 
  where the columns \code{id_i} and \code{id_t} 
  indicate the country and year respectively.
}
\source{
The prepared data is sourced from OECD and IMF's 
  \href{https://legacydata.imf.org/?sk=4c514d48-b6ba-49ed-8ab9-52b0c1a0179b}{\emph{International Financial Statistics}}
   of the year 1998, see the open 
  \href{https://www.imf.org/en/About/copyright-and-terms#data}{terms of use}. 
  Employed by Carrion-i-Silvestre and Surdeanu (2011:24, Ch.6.1), it has been 
  originally compiled and described in the unpublished appendix of Mark and 
  Sul (2003). See the related working paper of Mark and Sul (1999, Appendix B).
}
\usage{
data("MDEM")
}
\description{
The data set \code{MDEM} consists of 
  annual observations for the nominal short-term interest rate \eqn{R} and 
  the logarithm of the real money aggregate \eqn{m1} and real GDP \eqn{gdp}.
  It covers the period 1957 to 1996 \eqn{(T=40)} for \eqn{N=19} countries.
}
\references{
Carrion-i-Silvestre, J. L., and Surdeanu L. (2011): 
  "Panel Cointegration Rank Testing with Cross-Section Dependence", 
  \emph{Studies in Nonlinear Dynamics & Econometrics}, 15 (4), pp. 1-43.

Mark, N. C., and Sul, D. (1999): 
  "A Computationally Simple Cointegration Vector Estimator for Panel Data",
  Working Paper, Department of Economics, Ohio State University.

Mark, N. C., and Sul, D. (2003): 
  "Cointegration Vector Estimation by Panel DOLS and Long-Run Money Demand," 
  \emph{Oxford Bulletin of Economics and Statistics}, 65, pp. 655-680.
}
\seealso{
Other data sets: 
\code{\link{ERPT}},
\code{\link{EURO}},
\code{\link{EU_w}},
\code{\link{ICAP}},
\code{\link{MERM}},
\code{\link{PCAP}},
\code{\link{PCIT}}
}
\concept{data sets}
\keyword{datasets}
