% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvars.R
\docType{data}
\name{EURO}
\alias{EURO}
\title{Data set on the \emph{Euro Monetary Policy Transmission}}
\format{
A list-format data panel of class '\code{list}' 
  containing 15 '\code{data.frame}' objects with named time series.
}
\source{
The prepared \emph{Eurostat} data set is directly obtainable from the 
  \emph{ZBW Journal Data Archive}: \doi{10.15456/jae.2024044.1425287131}. 
  This is open data under the \href{https://creativecommons.org/licenses/by/4.0/}{CC BY 4.0 license} 
  in accordance with the deposit license of the \emph{ZBW Journal Data Archive}.
}
\usage{
data("EURO")
}
\description{
The data set \code{EURO} is a list of 15 '\code{data.frame}' objects,
  each consisting of quarterly observations for 
  \itemize{
  \item the first-difference of log real GDP 
        on national \eqn{dl\_GDP} or aggregated EA-level \eqn{EA\_dl\_GDP}, 
  \item the annualized inflation of the (log) GDP deflator
        on national \eqn{dl\_deflator} or aggregated EA-level \eqn{EA\_pi}, 
  \item the EA-wide short-term interest rate \eqn{IR}, 
  \item the EA-wide option-adjusted bond spreads \eqn{BBB}, 
  \item the first-difference of log real GDP in the remaining countries \eqn{dl\_GDP\_EA}, 
  \item the weighted inflation in the remaining countries \eqn{dl\_deflator\_EA}, 
  \item the inflation of a world commodity price index \eqn{WCP}, 
  \item the US effective federal funds rate \eqn{US\_FFR}, 
  \item the trade volume in percentage of GDP \eqn{trade}, and 
  \item the government spending in percentage of GDP \eqn{ge}. 
  }
  The data covers the period Q1 2001 to Q1 2020 \eqn{(T=77)} for 
  the aggregate of the Euro area (EA, first element in list) and 
  \eqn{N=14} of its member countries (subsequent 14 elements in list).
}
\references{
Herwartz, H., and Wang, S. (2024): 
  "Statistical Identification in Panel Structural Vector Autoregressive 
  Models based on Independence Criteria", 
  \emph{Journal of Applied Econometrics}, 39 (4), pp. 620-639.
}
\seealso{
Other data sets: 
\code{\link{ERPT}},
\code{\link{EU_w}},
\code{\link{ICAP}},
\code{\link{MDEM}},
\code{\link{MERM}},
\code{\link{PCAP}},
\code{\link{PCIT}}
}
\concept{data sets}
\keyword{datasets}
