% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differences.R
\name{prec_riskratio}
\alias{prec_riskratio}
\title{Sample size or precision for risk ratio}
\usage{
prec_riskratio(
  p1,
  p2,
  n1 = NULL,
  r = 1,
  conf.width = NULL,
  conf.level = 0.95,
  method = c("koopman", "katz"),
  ...
)
}
\arguments{
\item{p1}{risk among exposed.}

\item{p2}{risk among unexposed.}

\item{n1}{number of patients in exposed group.}

\item{r}{allocation ratio (relative size of unexposed and exposed cohort
(\code{n2} / \code{n1})).}

\item{conf.width}{precision (the full width of the confidence interval).}

\item{conf.level}{confidence level.}

\item{method}{Exactly one of \code{koopman} (\emph{default}), \code{katz}.
Methods can be abbreviated.}

\item{...}{other arguments to uniroot (e.g. \code{tol}).}
}
\description{
\code{prec_riskratio} returns the risk ratio and the sample size or the
precision for the provided proportions.
}
\details{
Exactly one of the parameters \code{n1} or \code{conf.width} must be passed as NULL,
and that parameter is determined from the other.

Koopman (\code{koopman}) provides an asymptotic score confidence interval
that is always consistent with Pearsons chi-squared test. It is the
recommended interval (Fagerland et al.).

Katz (\code{katz}) use a logarithmic transformation to calculate the
confidence interval. The CI cannot be computed if one of the proportions is
zero. If both proportions are 1, the estimate of the standard error becomes
zero, resulting in a CI of [1, 1].

\code{\link[stats]{uniroot}} is used to solve n for the katz, and koopman
method.
}
\examples{
# Validate function with example in Fagerland et al. (2015), Table 5.
prec_riskratio(p1 = 7/34, p2 = 1/34, n1 = 34, r = 1, met = "katz")
# 7 (0.91 to 54)
prec_riskratio(p1 = 7/34, p2 = 1/34, n1 = 34, r = 1, met = "koopman")
# 7 (1.21 to 43)

# Validate the Koopman method with example in Koopman (1984)
prec_riskratio(p1 = 36/40, p2 = 16/80, n1 = 40, r = 2, met = "koopman")
# 4.5 (2.94 to 7.15)
}
\references{
Fagerland MW, Lydersen S, and Laake P (2015). \emph{Recommended confidence
intervals for two independent binomial proportions}, Statistical methods in
medical research 24(2):224-254.

Katz D, Baptista J, Azen SP, and Pike MC (1978) \emph{Obtaining Confidence
Intervals for the Risk Ratio in Cohort Studies}, Biometrics 34:469-474.

Koopman PAR (1984) \emph{Confidence Intervals for the Ratio of Two Binomial
Proportions}, Biometrics 40:513-517.
}
