% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotSilhouetteOptimization}
\alias{plotSilhouetteOptimization}
\title{Plot silhouette optimization results}
\usage{
plotSilhouetteOptimization(optimization_result, highlight_best = TRUE, ...)
}
\arguments{
\item{optimization_result}{Result from \code{\link{optimize_resolution}}}

\item{highlight_best}{Logical. Highlight optimal resolution. Default is TRUE.}

\item{...}{Additional arguments}
}
\value{
A ggplot object
}
\description{
Creates a plot showing silhouette score and cluster count across resolution values.
}
\examples{
\donttest{
data(HVGERM)
d <- igDistance(HVGERM[1:30], method = "hamming")
g <- distance_to_graph(d)
opt <- optimize_resolution(g, d, target_clusters = 5)
plotSilhouetteOptimization(opt)
}

}
\seealso{
\code{\link{optimize_resolution}}, \code{\link{igClust}}
}
