% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_detection.R
\name{distance_to_graph}
\alias{distance_to_graph}
\title{Convert distance matrix to weighted graph}
\usage{
distance_to_graph(distance_matrix)
}
\arguments{
\item{distance_matrix}{A distance matrix or dist object}
}
\value{
An igraph object with weighted edges
}
\description{
Converts a distance matrix to a weighted igraph object using a log transform
that spreads small distances and produces weights in [0,1].
}
\details{
The transformation uses a log-based similarity measure:
\enumerate{
\item Normalize distances by max distance
\item Apply -log transform to convert to similarity
\item Normalize similarities to [0,1] range
\item Create weighted undirected graph
}
}
\examples{
data(HVGERM)
d <- igDistance(HVGERM[1:10], method = "hamming")
g <- distance_to_graph(d)

}
\seealso{
\code{\link{detect_communities_leiden}}, \code{\link{igClust}}
}
