% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguReporter.R
\name{pgu.reporter}
\alias{pgu.reporter}
\title{pgu.reporter}
\format{
[R6::R6Class] object.
}
\description{
Creates a human readable report file of the pguIMP analysis in odf format via rmarkdown and latex.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\details{
I run at the end of the analysis.
}
\author{
Sebastian Malkusch
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{filename}}{Returns the instance variable filename
(character)}

\item{\code{setFilename}}{Sets the instance variable filename to name.
(character)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-pgu.reporter-new}{\code{pgu.reporter$new()}}
\item \href{#method-pgu.reporter-finalize}{\code{pgu.reporter$finalize()}}
\item \href{#method-pgu.reporter-print}{\code{pgu.reporter$print()}}
\item \href{#method-pgu.reporter-write_report}{\code{pgu.reporter$write_report()}}
\item \href{#method-pgu.reporter-clone}{\code{pgu.reporter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.reporter-new"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.reporter-new}{}}}
\subsection{Method \code{new()}}{
Creates and returns a new `pgu.reporter` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.reporter$new(name = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Filename of the report pdf.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `pgu.reporter` object.
(pguIMP::pgu.report)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.reporter-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.reporter-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clears the heap and
indicates that instance of `pgu.reporter` is removed from heap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.reporter$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.reporter-print"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.reporter-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a `pgu.reporter` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.reporter$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.reporter-write_report"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.reporter-write_report}{}}}
\subsection{Method \code{write_report()}}{
Writes a report of the pguIMP analysis to a pdf file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.reporter$write_report(obj)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{obj}}{A list of class objects that are passed to the rmarkdown script.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
t.b.a.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.reporter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.reporter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.reporter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
