% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_software.R
\name{pre_gtdb_tk}
\alias{pre_gtdb_tk}
\title{Preprocess GTDB-Tk Classification Results}
\usage{
pre_gtdb_tk(classify_dir)
}
\arguments{
\item{classify_dir}{A character string specifying the path to the GTDB-Tk \code{classify} output directory.
This directory should contain files like \code{gtdbtk.bac120.summary.tsv}, \code{gtdbtk.bac120.classify.tree}, etc.}
}
\value{
A list with two components:
\describe{
\item{gtdb_res}{A data frame containing the combined taxonomic classification for all genomes.
The \code{classification} column is parsed into standard taxonomic ranks (Domain to Species).}
\item{tree}{A phylogenetic tree (phylo object) combining the bacterial and (if present) archaeal trees.}
}
}
\description{
This function reads and processes the output files from a GTDB-Tk \code{classify} workflow.
It combines bacterial (bac120) and archaeal (ar53) classification summaries and phylogenetic trees (if available) into a unified format.
}
\details{
The function performs the following steps:
\enumerate{
\item Checks if the provided directory exists and contains the necessary \verb{*.summary.tsv} files.
\item Reads the bacterial backbone tree.
\item If an archaeal tree file exists, it binds it to the bacterial tree.
\item Reads and combines all \verb{*.summary.tsv} files in the directory.
\item Parses the semicolon-separated \code{classification} string into separate columns for each taxonomic rank.
\item Ensures the resulting taxonomy table has standard ranks (Domain, Phylum, Class, Order, Family, Genus, Species).
}
}
