% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcomp_ml.R
\name{gcomp_ml.boot}
\alias{gcomp_ml.boot}
\title{Bootstrap for G-computation via Maximum Likelihood}
\usage{
gcomp_ml.boot(
  data,
  indices,
  R,
  formula = NULL,
  family,
  trt_var,
  ref_trt = NA,
  comp_trt = NA,
  rho = NA,
  N = 1000,
  marginal_distns = NA,
  marginal_params = NA,
  ald
)
}
\arguments{
\item{data}{A data frame containing the original individual participant data (IPD).}

\item{indices}{A vector of indices supplied by the bootstrapping function,
used to resample \code{data}.}

\item{formula}{Linear regression \code{formula} object. Prognostic factors (PF) are main effects and effect modifiers (EM) are
interactions with the treatment variable, e.g., y ~ X1 + trt + trt:X2. For covariates as both PF and EM use \code{*} syntax.}

\item{family}{A 'family' object specifying the distribution and link function (e.g., 'binomial').
See stats::family() for more details.}

\item{rho}{A named square matrix specifying the correlation between covariates
for synthetic data generation. Defaults to \code{NA}, assuming independence.}

\item{N}{Synthetic sample size for G-computation}

\item{marginal_distns, marginal_params}{Marginal distributions and parameters}

\item{ald}{A data frame of aggregate-level data providing covariate distributions.}
}
\value{
A single numeric value representing the relative treatment effect
}
\description{
This is a statistic function intended for use with a bootstrapping function
(e.g., \code{\link[boot:boot]{boot::boot()}}). On each bootstrap sample of the data, it calculates
a relative treatment effect (e.g., log odds ratio, log relative risk, or
risk difference) using G-computation with maximum likelihood.
}
\seealso{
\code{\link[=strategy_gcomp_ml]{strategy_gcomp_ml()}}
}
\keyword{internal}
