% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addIndirect.R
\name{addIndirectLin}
\alias{addIndirectLin}
\title{Add linear indirect response model}
\usage{
addIndirectLin(
  ui,
  stim = c("in", "out"),
  inhib = c("in", "out"),
  ek = "Ek",
  ik = "Ik",
  kin = "kin",
  kout = "kout",
  cc = "Cc",
  R = "R",
  effect = "effect"
)
}
\arguments{
\item{ui}{rxode2 model}

\item{stim}{what type of stimulation indirect response model:

- `in`: stimulation of input

- `out`: stimulation of output}

\item{inhib}{what type of inhibition indirect response model:

- `in`: inhibition of input

- `out`: inhibition of output}

\item{ek}{simulation linear constant}

\item{ik}{inhibition linear constant}

\item{kin}{this is the kin parameter name}

\item{kout}{this is the kout parameter name}

\item{cc}{the concentration value}

\item{R}{drug response compartment}

\item{effect}{the effect variable that will be modeled}
}
\value{
model with linear indirect effect added

Note that while linear indirect effects are not common, it allows an easier
hook to produce other standard effect curves like Emax/Imax, Hill, etc.
}
\description{
Add linear indirect response model
}
\examples{

readModelDb("PK_2cmt_no_depot") |> addIndirectLin(stim="in")

readModelDb("PK_2cmt_no_depot") |> addIndirectLin(stim="out")

readModelDb("PK_2cmt_no_depot") |> addIndirectLin(inhib="in")

readModelDb("PK_2cmt_no_depot") |> addIndirectLin(inhib="out")

}
\seealso{
Other Indirect response: 
\code{\link{addIndirect}()},
\code{\link{convertKinR0}()}
}
\author{
Matthew L. Fidler
}
\concept{Indirect response}
