% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-class.R
\docType{class}
\name{dualr-class}
\alias{dualr-class}
\title{Dual Number Class for Automatic Differentiation}
\description{
S4 class representing a dual number \eqn{a + b\varepsilon}
where \eqn{\varepsilon^2 = 0}. The \code{value} slot holds the primal
value and the \code{deriv} slot holds the tangent (derivative) component.
Both slots accept \code{ANY} type to support nested duals for higher-order
derivatives.
}
\section{Slots}{

\describe{
\item{\code{value}}{The primal (function) value. Numeric for first-order duals,
or another dual for higher-order.}

\item{\code{deriv}}{The tangent (derivative) component. Numeric for first-order
duals, or another dual for higher-order.}
}}

