% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{mp_design}
\alias{mp_design}
\title{Create a study design specification}
\usage{
mp_design(clusters, trials_per_cell = 1, notes = NULL)
}
\arguments{
\item{clusters}{Named list of positive integers. Example: \code{list(subject = 50, item = 30)}.}

\item{trials_per_cell}{Positive integer. Number of repeated observations per design cell.}

\item{notes}{Optional free text.}
}
\value{
An object of class \code{mp_design}.
}
\description{
\code{mp_design()} encodes how data will be collected: cluster sizes and repeated
measurements. It does not encode effect sizes or analysis decisions.
}
\examples{
d <- mp_design(clusters = list(subject = 40), trials_per_cell = 10)
d
}
