% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extgp.R
\name{egp-function}
\alias{egp-function}
\alias{egp.ll}
\alias{egp.retlev}
\title{Extended generalised Pareto log likelihood}
\usage{
egp.ll(
  xdat,
  thresh,
  par,
  model = c("pt-beta", "pt-gamma", "pt-power", "gj-tnorm", "gj-beta", "exptilt",
    "logist")
)

egp.retlev(
  xdat,
  thresh,
  par,
  model = c("pt-beta", "pt-gamma", "pt-power", "gj-tnorm", "gj-beta", "exptilt",
    "logist"),
  p,
  confint = FALSE,
  plot = TRUE
)
}
\arguments{
\item{xdat}{vector of observations, greater than the threshold}

\item{thresh}{threshold value}

\item{par}{parameter vector (\eqn{\kappa}, \eqn{\sigma}, \eqn{\xi}).}

\item{model}{a string indicating which extended family to fit}

\item{p}{extreme event probability; \code{p} must be greater than the rate of exceedance for the calculation to make sense. See \bold{Details}.}

\item{plot}{logical; if \code{TRUE}, a plot of the return levels}
}
\description{
This function provides the log-likelihood and quantiles for the different extended generalized Pareto distributions. All families share the same tail index as the generalized Pareto, and reduce to the latter when \code{kappa=1}.
}
\keyword{internal}
