% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specdens.R
\name{angmeas}
\alias{angmeas}
\title{Rank-based transformation to angular measure}
\usage{
angmeas(
  xdat,
  thresh,
  Rnorm = c("l1", "l2", "linf"),
  Anorm = c("l1", "l2", "linf", "arctan"),
  marg = c("frechet", "pareto"),
  wgt = c("empirical", "euclidean"),
  region = c("sum", "min", "max"),
  is.angle = FALSE,
  ...
)
}
\arguments{
\item{xdat}{an \code{n} by \code{d} sample matrix}

\item{thresh}{threshold of length 1 for \code{'sum'}, or \code{d} marginal thresholds otherwise.}

\item{Rnorm}{character string indicating the norm for the radial component.}

\item{Anorm}{character string indicating the norm for the angular component. \code{arctan} is only implemented for \eqn{d=2}}

\item{marg}{character string indicating choice of marginal transformation, either to Frechet or Pareto scale}

\item{wgt}{character string indicating weighting function for the equation. Can be based on Euclidean or empirical likelihood for the mean}

\item{region}{character string specifying which observations to consider (and weight). \code{'sum'} corresponds to a radial threshold
\eqn{\sum x_i > }\code{thresh}, \code{'min'} to \eqn{\min x_i >}\code{thresh} and \code{'max'} to \eqn{\max x_i >}\code{thresh}.}

\item{is.angle}{logical indicating whether observations are already angle with respect to \code{region}. Default to \code{FALSE}.}

\item{...}{additional arguments}
}
\value{
a list with arguments \code{ang} for the \eqn{d-1} pseudo-angular sample, \code{rad} with the radial component
and possibly \code{wts} if \code{Rnorm='l1'} and the empirical likelihood algorithm converged. The Euclidean algorithm always returns weights even if some of these are negative.

a list with components
\itemize{
\item \code{ang} matrix of pseudo-angular observations
\item \code{rad} vector of radial contributions
\item \code{wts} empirical or Euclidean likelihood weights for angular observations
}
}
\description{
The method uses the pseudo-polar transformation for suitable norms, transforming
the data to pseudo-observations, than marginally to unit Frechet or unit Pareto.
Empirical or Euclidean weights are computed and returned alongside with the angular and
radial sample for values above threshold(s) \code{thresh}, specified in terms of quantiles
of the radial component \code{R} or marginal quantiles. Only complete tuples are kept.
}
\details{
The empirical likelihood weighted mean problem is implemented for all thresholds,
 while the Euclidean likelihood is only supported for diagonal thresholds specified
 via \code{region=sum}.
}
\examples{
x <- rmev(n = 25, d = 3, param = 0.5, model = 'log')
wts <- angmeas(xdat = x, Rnorm = 'l1', Anorm = 'l1', marg = 'frechet', wgt = 'empirical')
wts2 <- angmeas(xdat = x, Rnorm = 'l2', Anorm = 'l2', marg = 'pareto')
}
\references{
Einmahl, J.H.J. and J. Segers (2009). Maximum empirical likelihood estimation of the spectral measure of an extreme-value distribution, \emph{Annals of Statistics}, \bold{37}(5B), 2953--2989.

de Carvalho, M. and B. Oumow and J. Segers and M. Warchol (2013). A Euclidean likelihood estimator for bivariate tail dependence, \emph{Comm. Statist. Theory Methods}, \bold{42}(7), 1176--1192.

Owen, A.B. (2001). \emph{Empirical Likelihood}, CRC Press, 304p.
}
\author{
Leo Belzile
}
