% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuildConfounderMap.R
\name{BuildConfounderMap}
\alias{BuildConfounderMap}
\title{BuildConfounderMap}
\usage{
BuildConfounderMap(
  metaDeconfOutput,
  q_cutoff = 0.1,
  featureColor = c("black"),
  featureNames = NULL,
  metaVariableNames = NULL,
  d_col = c("blue", "white", "red"),
  d_range = "full",
  trusted = c("OK_sd", "OK_nc", "OK_d", "AD")
)
}
\arguments{
\item{metaDeconfOutput}{output of a metadeconfound run}

\item{q_cutoff}{optional FDR-value cutoff used to remove
low-significance entries from data}

\item{featureColor}{optional vector of colors named after each unique feature in metaDeconfOutput}

\item{featureNames}{optional two-column-dataframe containing corresponding
"human-readable" names to the "machine-readable" feature names used as
row.names in metaDeconfOutput. These human readable
names will be displayed in the final plot. First column: machine-readable,
second column: human-readable.}

\item{metaVariableNames}{optional two-column-dataframe containing
corresponding  "human-readable" names to the "machine-readable" metadata
names used as column names in metaDeconfOutput. These human readable
names will be displayed in the final plot. First column: machine-readable,
second column: human-readable.}

\item{d_col}{set color range for effect size as c(minimum, middle, maximum),
default c("red", "white", "blue")}

\item{d_range}{range of effect size colors shown; "full": (default) range from
-1 to +1 (best for comparability between multiple plots);
"fit": range reduced according to maximum and minimum effect size
present in resulting plot (better color resolution for weaker effects)}

\item{trusted}{character vector of confounding status labels to be treated
as trustworthy, not-confounded signal. default = c("OK_sd", "OK_nc", "OK_d", "AD")}
}
\value{
list of ggplot2 objects
}
\description{
BuildConfounderMap summarizes confounder analysis of a \link[metadeconfoundR]{MetaDeconfound} output in a circle plot
}
\details{
for more details and explanations please see the package vignette.
}
\examples{
data(reduced_feature)
data(metaMatMetformin)
\donttest{
example_output <- MetaDeconfound(featureMat = reduced_feature,
                                  metaMat = metaMatMetformin,
                                  logLevel = "ERROR")

plotObject <- BuildConfounderMap(example_output)
library(ggraph)
plotObject$MS0001
}

}
\author{
Kilian Dahm
}
