% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignTimeSeries.R
\name{alignTimeSeries}
\alias{alignTimeSeries}
\alias{mergePalaeoData}
\title{Align and join multiple time series to a common temporal resolution}
\usage{
alignTimeSeries(
  datasets.list = NULL,
  time.column = NULL,
  interpolation.interval = NULL
)

mergePalaeoData(
  datasets.list = NULL,
  time.column = NULL,
  interpolation.interval = NULL
)
}
\arguments{
\item{datasets.list}{list of dataframes, as in \code{datasets.list = list(dataset1 = df1, dataset2 = df2)}. The provided dataframes must have a time column with the same column name and the same units of time. Non-numeric columns in these dataframes are ignored. Default: \code{NULL}.}

\item{time.column}{character string, name of the time column of the datasets provided in \code{datasets.list}. Default: \code{NULL}.}

\item{interpolation.interval}{numeric, temporal resolution of the output data, in the same units as the time columns of the input data. Default: \code{NULL}.}
}
\value{
A dataframe with every column of the initial dataset interpolated to a regular time grid of resolution defined by \code{interpolation.interval}. Column names follow the form datasetName.columnName, so the origin of columns can be tracked.
}
\description{
Aligns multiple time series datasets to a common temporal resolution
using LOESS interpolation and joins them into a single dataframe. This is
useful when combining datasets with different sampling intervals.
}
\details{
This function fits a \code{\link{loess}} model of the form \code{y ~ x}, where \code{y} is any numeric column in the input datasets and \code{x} is the column given by the \code{time.column} argument. The model is used to interpolate column \code{y} on a regular time series of intervals equal to \code{interpolation.interval}. All numeric columns in every provided dataset go through this process to generate the final data with samples separated by regular time intervals. Non-numeric columns are ignored and absent from the output dataframe.
}
\examples{

\donttest{
#loading data
data(pollen)
data(climate)

x <- alignTimeSeries(
 datasets.list = list(
   pollen=pollen,
   climate=climate
 ),
 time.column = "age",
 interpolation.interval = 0.2
 )

 }
}
\seealso{
Other data_preparation: 
\code{\link{lagTimeSeries}()}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
\concept{data_preparation}
