% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processor_factory.R
\name{ProcessorFactory}
\alias{ProcessorFactory}
\title{Processor Factory Base Class}
\format{
An R6 class
}
\description{
Abstract base class for creating processors specific to different plotting systems.
Each plotting system should have its own factory implementation that creates
the appropriate processors for different plot types.
}
\keyword{Abstract}
\keyword{a}
\keyword{create}
\keyword{for}
\keyword{internal}
\keyword{method}
\keyword{plot}
\keyword{processor}
\keyword{specific}
\keyword{to}
\keyword{type}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ProcessorFactory-create_processor}{\code{ProcessorFactory$create_processor()}}
\item \href{#method-ProcessorFactory-get_supported_types}{\code{ProcessorFactory$get_supported_types()}}
\item \href{#method-ProcessorFactory-supports_plot_type}{\code{ProcessorFactory$supports_plot_type()}}
\item \href{#method-ProcessorFactory-get_system_name}{\code{ProcessorFactory$get_system_name()}}
\item \href{#method-ProcessorFactory-clone}{\code{ProcessorFactory$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProcessorFactory-create_processor"></a>}}
\if{latex}{\out{\hypertarget{method-ProcessorFactory-create_processor}{}}}
\subsection{Method \code{create_processor()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProcessorFactory$create_processor(plot_type, plot_object)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_type}}{The type of plot (e.g., "bar", "line", "point")}

\item{\code{plot_object}}{The plot object to process}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Processor instance for the specified plot type
Abstract method to get list of supported plot types
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProcessorFactory-get_supported_types"></a>}}
\if{latex}{\out{\hypertarget{method-ProcessorFactory-get_supported_types}{}}}
\subsection{Method \code{get_supported_types()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProcessorFactory$get_supported_types()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector of supported plot types
Check if a plot type is supported by this factory
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProcessorFactory-supports_plot_type"></a>}}
\if{latex}{\out{\hypertarget{method-ProcessorFactory-supports_plot_type}{}}}
\subsection{Method \code{supports_plot_type()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProcessorFactory$supports_plot_type(plot_type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_type}}{The plot type to check}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if supported, FALSE otherwise
Get system name (should be overridden by subclasses)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProcessorFactory-get_system_name"></a>}}
\if{latex}{\out{\hypertarget{method-ProcessorFactory-get_system_name}{}}}
\subsection{Method \code{get_system_name()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProcessorFactory$get_system_name()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
System name string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProcessorFactory-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ProcessorFactory-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProcessorFactory$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
