% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_r_histogram_layer_processor.R
\name{BaseRHistogramLayerProcessor}
\alias{BaseRHistogramLayerProcessor}
\title{Base R Histogram Layer Processor}
\description{
Processes Base R histogram plot layers using verified data extraction
and selector generation logic.
}
\keyword{internal}
\section{Super class}{
\code{\link[maidr:LayerProcessor]{maidr::LayerProcessor}} -> \code{BaseRHistogramLayerProcessor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BaseRHistogramLayerProcessor-process}{\code{BaseRHistogramLayerProcessor$process()}}
\item \href{#method-BaseRHistogramLayerProcessor-extract_data}{\code{BaseRHistogramLayerProcessor$extract_data()}}
\item \href{#method-BaseRHistogramLayerProcessor-generate_selectors}{\code{BaseRHistogramLayerProcessor$generate_selectors()}}
\item \href{#method-BaseRHistogramLayerProcessor-find_rect_grobs}{\code{BaseRHistogramLayerProcessor$find_rect_grobs()}}
\item \href{#method-BaseRHistogramLayerProcessor-generate_selectors_from_grob}{\code{BaseRHistogramLayerProcessor$generate_selectors_from_grob()}}
\item \href{#method-BaseRHistogramLayerProcessor-extract_axis_titles}{\code{BaseRHistogramLayerProcessor$extract_axis_titles()}}
\item \href{#method-BaseRHistogramLayerProcessor-extract_main_title}{\code{BaseRHistogramLayerProcessor$extract_main_title()}}
\item \href{#method-BaseRHistogramLayerProcessor-clone}{\code{BaseRHistogramLayerProcessor$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="apply_scale_mapping"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-apply_scale_mapping'><code>maidr::LayerProcessor$apply_scale_mapping()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="extract_layer_axes"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-extract_layer_axes'><code>maidr::LayerProcessor$extract_layer_axes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="get_last_result"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-get_last_result'><code>maidr::LayerProcessor$get_last_result()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="get_layer_index"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-get_layer_index'><code>maidr::LayerProcessor$get_layer_index()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="initialize"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-initialize'><code>maidr::LayerProcessor$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="needs_reordering"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-needs_reordering'><code>maidr::LayerProcessor$needs_reordering()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="reorder_layer_data"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-reorder_layer_data'><code>maidr::LayerProcessor$reorder_layer_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="maidr" data-topic="LayerProcessor" data-id="set_last_result"><a href='../../maidr/html/LayerProcessor.html#method-LayerProcessor-set_last_result'><code>maidr::LayerProcessor$set_last_result()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRHistogramLayerProcessor-process"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRHistogramLayerProcessor-process}{}}}
\subsection{Method \code{process()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRHistogramLayerProcessor$process(
  plot,
  layout,
  built = NULL,
  gt = NULL,
  layer_info = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRHistogramLayerProcessor-extract_data"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRHistogramLayerProcessor-extract_data}{}}}
\subsection{Method \code{extract_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRHistogramLayerProcessor$extract_data(layer_info)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRHistogramLayerProcessor-generate_selectors"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRHistogramLayerProcessor-generate_selectors}{}}}
\subsection{Method \code{generate_selectors()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRHistogramLayerProcessor$generate_selectors(layer_info, gt = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRHistogramLayerProcessor-find_rect_grobs"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRHistogramLayerProcessor-find_rect_grobs}{}}}
\subsection{Method \code{find_rect_grobs()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRHistogramLayerProcessor$find_rect_grobs(grob, call_index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRHistogramLayerProcessor-generate_selectors_from_grob"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRHistogramLayerProcessor-generate_selectors_from_grob}{}}}
\subsection{Method \code{generate_selectors_from_grob()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRHistogramLayerProcessor$generate_selectors_from_grob(
  grob,
  call_index = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRHistogramLayerProcessor-extract_axis_titles"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRHistogramLayerProcessor-extract_axis_titles}{}}}
\subsection{Method \code{extract_axis_titles()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRHistogramLayerProcessor$extract_axis_titles(layer_info)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRHistogramLayerProcessor-extract_main_title"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRHistogramLayerProcessor-extract_main_title}{}}}
\subsection{Method \code{extract_main_title()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRHistogramLayerProcessor$extract_main_title(layer_info)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRHistogramLayerProcessor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRHistogramLayerProcessor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRHistogramLayerProcessor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
