% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-fit.R
\name{sampler.likelihood_model}
\alias{sampler.likelihood_model}
\title{Estimate the sampling distribution of the MLE for a likelihood model.}
\usage{
\method{sampler}{likelihood_model}(x, df, par, ..., nthreads = 1L)
}
\arguments{
\item{x}{The likelihood model}

\item{df}{Data frame to bootstrap from}

\item{par}{Initial parameter values}

\item{...}{Additional arguments to pass into the likelihood model}

\item{nthreads}{The number of threads to use for parallelization}
}
\value{
A function that returns a bootstrapped sampling distribution of an
MLE (fisher_boot object).
}
\description{
We use the bootstrap method. In other words, we treat the data as an
empirical distribution and sample from it to get a new dataset, then
we fit the model to that dataset and return the MLE. We do this R
times and return the R MLEs.
}
\details{
This is the default method, but if you want to use a different method,
you should define your own method for your likelihood model.
}
