% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-generics.R
\name{fim}
\alias{fim}
\title{Fisher information matrix method}
\usage{
fim(model, ...)
}
\arguments{
\item{model}{A likelihood model}

\item{...}{Additional arguments}
}
\value{
Function that computes the FIM given a parameter vector and sample size
}
\description{
This function calculates the Fisher information matrix (FIM), an expectation
over the data-generating process (DGP). The FIM is a crucial concept in
statistics because it provides information about the precision of estimates
and the amount of information that data carries about an unknown parameter.
}
\details{
FIM is a function of the parameters, and is used to compute the standard
errors of the parameters. It is also used to compute the covariance matrix of
the parameters, which is in turn used to compute standard errors of the
parameters.

Additionally, FIM is used to compute the Cramer-Rao lower bound (CRLB),
the inverse of the FIM. CRLB represents the lower limit of the variance that
an unbiased estimator can attain. This is used to compute the asymptotic
relative efficiency (ARE) of an estimator of the parameters, which is the
ratio of the variance of the estimator to the CRLB.

The function computes FIM(x)(theta), the FIM of the likelihood model \code{x}, is
based on the following formulas:

\if{html}{\out{<div class="sourceCode">}}\preformatted{FIM(x)(theta) = E[-loglik_hessian(x)(ob,theta)]
FIM(x)(theta) = E[score(x)(ob,theta) \%*\% t(score(x)(ob,theta))]
}\if{html}{\out{</div>}}

where the expectation is taken with respect to ob ~ DGP. The first formula
is the expected hessian of the log-likelihood function, and the second formula
is the expected outer product of the score function. The two formulas are
equivalent.
}
