% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/model.R
\name{predictAssignments}
\alias{predictAssignments}
\alias{predictAssignments,lcModel-method}
\title{Predict the cluster assignments for new trajectories}
\usage{
predictAssignments(object, newdata = NULL, ...)

\S4method{predictAssignments}{lcModel}(object, newdata = NULL, strategy = which.max, ...)
}
\arguments{
\item{object}{The model.}

\item{newdata}{A \code{data.frame} of trajectory data for which to compute trajectory assignments.}

\item{...}{Not used.}

\item{strategy}{A function returning the cluster index based on the given \code{vector} of membership probabilities.
By default (\code{strategy = which.max}), trajectories are assigned to the most likely cluster.}
}
\value{
A \code{factor} of length \code{nrow(newdata)} that indicates the assigned cluster per trajectory per observation.
}
\description{
Predict the most likely cluster membership for each trajectory in the given data.
}
\details{
The default implementation uses \link{predictPostprob} to determine the cluster membership.
}
\examples{
\dontrun{
data(latrendData)
if (require("kml")) {
  model <- latrend(method = lcMethodKML("Y", id = "Id", time = "Time"), latrendData)
  predictAssignments(model, newdata = data.frame(Id = 999, Y = 0, Time = 0))
}
}
}
\seealso{
\link{predictPostprob} \link{predict.lcModel}

Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
