% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row-id.R
\name{check_id_disjoint}
\alias{check_id_disjoint}
\title{Check IDs are disjoint across datasets}
\usage{
check_id_disjoint(..., .id = ".id")
}
\arguments{
\item{...}{Data frames to check.}

\item{.id}{Column name for IDs (default: ".id").}
}
\value{
Invisibly returns a list with:
\itemize{
\item \code{disjoint}: TRUE if no overlaps found
\item \code{overlaps}: character vector of overlapping IDs (if any)
}
}
\description{
Verifies that ID columns don't overlap between datasets.
Useful before binding datasets to ensure no ID collisions.
}
\examples{
df1 <- add_id(data.frame(x = 1:3))
df2 <- add_id(data.frame(x = 4:6))
check_id_disjoint(df1, df2)

}
