% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/title_footers.R
\name{get_titles_from_file}
\alias{get_titles_from_file}
\title{Get Titles/Footers For Table From Sources}
\usage{
get_titles_from_file(
  id,
  file = .find_titles_file(input_path),
  input_path = ".",
  title_df = .read_titles_file(file)
)
}
\arguments{
\item{id}{(\code{character(1)})\cr The identifier for the table of interest.}

\item{file}{(\code{character(1)})\cr A path to CSV or xlsx file containing title
and footer information for one or more outputs. See Details. Ignored if
\code{title_df} is specified.}

\item{input_path}{(\code{character(1)})\cr A path to look for
titles.csv/titles.xlsx. Ignored if \code{file} or \code{title_df} is specified.}

\item{title_df}{(\code{data.frame})\cr A data.frame containing titles and footers for
one or more  outputs. See Details.}
}
\value{
List object containing: title, subtitles, main_footer, prov_footer
for the table of interest.  Note: the subtitles and prov_footer are
currently set to NULL. Suitable for use with \code{\link[=set_titles]{set_titles()}}.
}
\description{
Retrieves the titles and footnotes for a given table from a CSV/XLSX file or a data.frame.
}
\details{
Retrieves the titles for a given output id (see below) and outputs
a list containing the title and footnote objects supported by
rtables. Both titles.csv and titles.xlsx (\emph{if \code{readxl} is
installed}) files are supported, with titles.csv being checked
first.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     Data is expected to have `TABLE ID`, `IDENTIFIER`, and `TEXT` columns,
     where `IDENTIFIER` has the value `TITLE` for a title and `FOOT*` for
     footer materials where `*` is a positive integer. `TEXT` contains
     the value of the title/footer to be applied.
}\if{html}{\out{</div>}}
}
