% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_explain.R
\name{join_explain}
\alias{join_explain}
\title{Explain Row Count Changes After a Join}
\usage{
join_explain(result, x, y, by, type = NULL)
}
\arguments{
\item{result}{The result of a join operation.}

\item{x}{The original left data frame.}

\item{y}{The original right data frame.}

\item{by}{A character vector of column names used in the join.}

\item{type}{Character. The type of join that was performed. One of
\code{"left"}, \code{"right"}, \code{"inner"}, \code{"full"}. If \code{NULL} (default),
attempts to infer the join type from row counts.}
}
\value{
Invisibly returns a list with explanation details. Prints a
human-readable explanation.
}
\description{
After performing a join, use this function to understand why the row count
changed. It analyzes the original tables and the result to explain the
difference.
}
\examples{
orders <- data.frame(id = c(1, 2, 2, 3), value = 1:4)
customers <- data.frame(id = c(1, 2, 2, 4), name = c("A", "B1", "B2", "D"))

result <- merge(orders, customers, by = "id", all.x = TRUE)

# Explain why we got more rows than expected
join_explain(result, orders, customers, by = "id", type = "left")

}
\seealso{
\code{\link[=join_spy]{join_spy()}}, \code{\link[=join_diff]{join_diff()}}
}
