% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivo_tables.R
\encoding{UTF-8}
\name{ivo_table_masked}
\alias{ivo_table_masked}
\title{Create a masked frequency/contingency table}
\usage{
ivo_table_masked(
  df,
  cell = 5,
  extra_header = TRUE,
  exclude_missing = FALSE,
  missing_string = "(Missing)",
  colsums = FALSE,
  rowsums = FALSE,
  sums_string = "Total",
  caption = NA,
  highlight_cols = NULL,
  highlight_rows = NULL,
  color = "darkgreen",
  font_name = "Arial",
  bold_cols = NULL,
  long_table = FALSE,
  remove_zero_rows = FALSE
)
}
\arguments{
\item{df}{A data frame with 1-4 columns}

\item{cell}{The largest value that will be masked. Defaults to 5, meaning that values between 1 and 5 are masked.}

\item{extra_header}{Should the variable name be displayed? Defaults to TRUE.}

\item{exclude_missing}{Whether to exclude missing values from the table. Defaults to FALSE.}

\item{missing_string}{A string used to indicate missing values. Defaults to "(Missing)".}

\item{colsums}{A logical indicating whether the sum of each column should be computed. Defaults to FALSE.}

\item{rowsums}{A logical indicating whether the sum of each row should be computed. Defaults to FALSE.}

\item{sums_string}{A string that is printed in the column/row where row/column sums are shown. Defaults to "Total".}

\item{caption}{An optional string containing a table caption.}

\item{highlight_cols}{A numeric vector containing the indices of the columns that should be highlighted.}

\item{highlight_rows}{A numeric vector containing the indices of the rows that should be highlighted.}

\item{color}{A named color or a color HEX code, used for the lines in the table. Defaults to "darkgreen".}

\item{font_name}{The name of the font to be used in the table. Defaults to "Arial".}

\item{bold_cols}{A numeric vector containing the indices of the columns that should use a bold font.}

\item{long_table}{For one-way tables: FALSE (the default) means that the table will be wide and consist of a single row, TRUE means that the table will be long and consist of a single column.}

\item{remove_zero_rows}{If set to TRUE, removes all rows that contain nothing but zeros. The default is FALSE.}
}
\value{
A stylized \code{flextable}.
}
\description{
\code{ivo_table_masked()} lets you easily create pretty masked tables. If you want the table without masked values use \code{ivo_table()} instead.
}
\details{
The functions \code{ivo_table()} and \code{ivo_table_masked()} takes a \code{data.frame} with 1-4 columns. The order of the columns in the \code{data.frame} will determine where they will be displayed in the table. The first column will always be displayed at the top of the table. If there are more than one column the following 2-4 columns will be displayed to the left in the order 2, 3, 4. To change how the columns are displayed in the table; change the place of the columns in the \code{data.frame} using \code{dplyr::select()}.
}
\examples{
# Generate example data
example_data <- data.frame(Year = sample(2020:2023, 50, replace = TRUE),
A = sample(c("Type 1", "Type 2"), 50, replace = TRUE),
B = sample(c("Apples", "Oranges", "Bananas"), 50, replace = TRUE),
C = sample(c("Swedish", "Norwegian", "Chilean"), 50, replace = TRUE))

### 1-way tables ###
data1 <- example_data |> dplyr::select(Year)
ivo_table_masked(data1) # No masking because all counts are >=5
ivo_table_masked(data1, cell = 15) # Counts below <=15 are masked

# With pipes
example_data |> dplyr::select(Year) |> ivo_table()

### 2-way tables ###
data2 <- example_data |> dplyr::select(A, B)
ivo_table_masked(data2)
ivo_table_masked(data2, cell = 7) # Counts <= 7 are masked
# Row and column sums are also masked:
ivo_table_masked(
data2,
cell = 3,
colsums = TRUE,
rowsums = TRUE)

### 3-way tables ###
data3 <- example_data |> dplyr::select(C, B, Year)
ivo_table_masked(
data3,
cell = 3,
caption = "Values between 1 and 3 are masked."
)

### 4-way tables ###
data4 <- example_data |> dplyr::select(Year, B, C, A)
ivo_table_masked(data4, colsums = TRUE, rowsums = TRUE)
}
\seealso{
{ivo_table_add_mask}
}
\author{
Måns Thulin and Kajsa Grind
}
