% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{arrange.ir}
\alias{arrange.ir}
\title{Arrange rows in \code{ir} objects by column values}
\source{
\code{\link[dplyr:arrange]{dplyr::arrange()}}
}
\usage{
arrange.ir(.data, ..., .by_group = FALSE)
}
\arguments{
\item{.data}{An object of class \code{ir}.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variables, or
functions of variables. Use \code{\link[dplyr:desc]{desc()}} to sort a variable in descending
order.}

\item{.by_group}{If \code{TRUE}, will sort first by grouping variable. Applies to
grouped data frames only.}
}
\value{
\code{.data} with arranged rows.
}
\description{
Arrange rows in \code{ir} objects by column values
}
\examples{
## arrange
dplyr::arrange(ir_sample_data, dplyr::desc(sample_type))


}
\seealso{
Other tidyverse: 
\code{\link{distinct.ir}()},
\code{\link{extract.ir}()},
\code{\link{filter-joins}},
\code{\link{filter.ir}()},
\code{\link{group_by}},
\code{\link{mutate}},
\code{\link{mutate-joins}},
\code{\link{nest}},
\code{\link{pivot_longer.ir}()},
\code{\link{pivot_wider.ir}()},
\code{\link{rename}},
\code{\link{rowwise.ir}()},
\code{\link{select.ir}()},
\code{\link{separate.ir}()},
\code{\link{separate_rows.ir}()},
\code{\link{slice}},
\code{\link{summarize}},
\code{\link{unite.ir}()}
}
\concept{tidyverse}
