% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{split.incidence2}
\alias{split.incidence2}
\title{Divide an incidence2 object in to it's implicit groupings}
\usage{
\method{split}{incidence2}(x, f, drop, ...)
}
\arguments{
\item{x}{An \link[=incidence]{incidence2} object.}

\item{f}{Not used. Present only for generic compatibility.}

\item{drop}{Not used. Present only for generic compatibility.}

\item{...}{Not used. Present only for generic compatibility.}
}
\value{
A list of tibbles contained the split data. This list also has a "key"
attribute which is a tibble with rows corresponding to the grouping of
each split.
}
\description{
Split divides and \link[=incidence]{incidence2} object in to it's
underlying groupings (count variable and optionally groups).
}
\examples{
\dontshow{.old <- data.table::setDTthreads(2)}
if (requireNamespace("outbreaks", quietly = TRUE)) {
    data(ebola_sim_clean, package = "outbreaks")
    ebola_sim_clean$linelist |>
        subset(!is.na(hospital)) |>
        incidence_(date_of_onset, hospital, interval = "isoweek") |>
        split()
}
\dontshow{data.table::setDTthreads(.old)}

}
