% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagine-main.R
\name{agenbagFilters}
\alias{agenbagFilters}
\title{Performs algorithms from Agenbag et al. (2003)}
\usage{
agenbagFilters(X, algorithm = c(1, 2), ...)
}
\arguments{
\item{X}{A numeric \code{matrix} used as main input.}

\item{algorithm}{\code{integer} specifying the type of method that will be
used. See Details.}

\item{...}{Not used.}
}
\value{
\code{agenbagFilters} returns a \code{matrix} object with the same
dimensions of \code{X}.
}
\description{
This function performs two (gradient) calculation approaches for
SST, as outlined in the paper by Agenbag et al. (2003).
}
\details{
Section 2.2.4 of the paper by Agenbag et al. (2003) introduces the following
two methods:
\describe{
 \item{\strong{Method 1: }}{Based on the equation
 \deqn{Y_{i,j}=\sqrt{(X_{i+1,j}-X_{i-1,j})^2 +(X_{i,j+1}-X_{i,j-1})^2}}}
 where \eqn{Y_{i,j}} represents the output value for each \eqn{X_{i,j}} pixel value
 of a given \eqn{X} matrix.
 \item{\strong{Method 2: }}{the standard deviation in a 3x3 pixel area centered on
 position \eqn{(i,j)}.}
}

As outlined in the original study, this method conducts searches within a
1-pixel vicinity of each point. For method 1, it only returns a value for
points where none of the four involved values are NA. Conversely, for method
2, the standard deviation calculation is performed only for points where at
least 3 non-NA values are found in the 3x3 neighborhood.
}
\examples{
data(wbImage)

# Agenbag, method 1
agenbag1 <- agenbagFilters(X = wbImage, algorithm = 1)

# Agenbag, method 2
agenbag2 <- agenbagFilters(X = wbImage, algorithm = 2)

# Plotting results
par(mfrow = c(3, 1), mar = rep(0, 4))

# Original
image(wbImage, axes = FALSE, col = gray.colors(n = 1e3))

# Calculated
cols <- hcl.colors(n = 1e3, palette = "YlOrRd", rev = TRUE)
image(agenbag1, axes = FALSE, col = cols)
image(agenbag2, axes = FALSE, col = cols)
}
\references{
Agenbag, J.J., A.J. Richardson, H. Demarcq, P. Freon, S. Weeks,
and F.A. Shillington. "Estimating Environmental Preferences of South African
Pelagic Fish Species Using Catch Size- and Remote Sensing Data". Progress in
Oceanography 59, No 2-3 (October 2003): 275-300.
(\doi{https://doi.org/10.1016/j.pocean.2003.07.004}).
}
