% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full.R
\name{generate_hybrid_ehr}
\alias{generate_hybrid_ehr}
\title{High-level wrapper to generate and export a hybrid EHR dataset}
\usage{
generate_hybrid_ehr(
  n_patients = 500,
  n_sites = 3,
  covid_focused = TRUE,
  include_ct_links = FALSE,
  output_dir,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{n_patients}{Number of unique patients.}

\item{n_sites}{Number of sites/hospitals to simulate.}

\item{covid_focused}{Logical; if TRUE, use COVID-era encounter and lab patterns.}

\item{include_ct_links}{Logical; if TRUE, add CT timing variables and a CT
severity score in the CT research view.}

\item{output_dir}{Directory for exported files.}

\item{seed}{Optional integer used to set the random seed for reproducibility.}

\item{verbose}{Logical; if TRUE, print progress messages to the console.}
}
\value{
A list with:
\describe{
\item{dataset}{The in-memory dataset list (as from \code{generate_hybrid_ehr_dataset}).}
\item{output_dir}{The output directory path where files were written.}
}

A list containing:
\describe{
\item{dataset}{Generated dataset object}
\item{output_dir}{Path to exported files}
}
}
\description{
High-level wrapper to generate and export a hybrid EHR dataset
}
\examples{
\donttest{
ehr <- generate_hybrid_ehr_dataset(
  n_patients = 10,
  seed = 123,
  verbose = FALSE
)

export_hybrid_ehr_dataset(
  ehr,
  output_dir = tempdir(),
  verbose = FALSE
)
}

}
