% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sinan.R
\name{sinan_variables}
\alias{sinan_variables}
\title{List SINAN Variables}
\usage{
sinan_variables(disease = "DENG", search = NULL)
}
\arguments{
\item{disease}{Character. Disease code (e.g., "DENG"). Currently not used
for filtering but reserved for future disease-specific variables.
Default: "DENG".}

\item{search}{Character. Optional search term to filter variables by
name or description. Case-insensitive and accent-insensitive.}
}
\value{
A tibble with columns: variable, description, type, section.
}
\description{
Returns a tibble with available variables in the SINAN microdata,
including descriptions and value types.
}
\examples{
sinan_variables()
sinan_variables(search = "sexo")
sinan_variables(search = "municipio")
}
\seealso{
Other sinan: 
\code{\link{sinan_cache_status}()},
\code{\link{sinan_clear_cache}()},
\code{\link{sinan_data}()},
\code{\link{sinan_dictionary}()},
\code{\link{sinan_diseases}()},
\code{\link{sinan_info}()},
\code{\link{sinan_years}()}
}
\concept{sinan}
