/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5Smodule.h" 

#include "H5private.h"  
#include "H5Eprivate.h" 
#include "H5Spkg.h"     

herr_t
H5S_debug(H5F_t *f, const void *_mesg, FILE *stream, int indent, int fwidth)
{
    const H5S_t *mesg = (const H5S_t *)_mesg;

    FUNC_ENTER_NOAPI_NOINIT_NOERR

    switch (H5S_GET_EXTENT_TYPE(mesg)) {
        case H5S_NULL:
            Rfprintf(stream, "%*s%-*s H5S_NULL\n", indent, "", fwidth, "Space class:");
            break;

        case H5S_SCALAR:
            Rfprintf(stream, "%*s%-*s H5S_SCALAR\n", indent, "", fwidth, "Space class:");
            break;

        case H5S_SIMPLE:
            Rfprintf(stream, "%*s%-*s H5S_SIMPLE\n", indent, "", fwidth, "Space class:");
            H5O_debug_id(H5O_SDSPACE_ID, f, &(mesg->extent), stream, indent + 3, MAX(0, fwidth - 3));
            break;

        case H5S_NO_CLASS:
        default:
            Rfprintf(stream, "%*s%-*s **UNKNOWN-%ld**\n", indent, "", fwidth,
                    "Space class:", (long)(H5S_GET_EXTENT_TYPE(mesg)));
            break;
    } 

    FUNC_LEAVE_NOAPI(SUCCEED)
} 
