% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_arima.R
\name{hanr_arima}
\alias{hanr_arima}
\title{Anomaly detector using ARIMA}
\usage{
hanr_arima()
}
\value{
\code{hanr_arima} object.
}
\description{
Fits an ARIMA model to the series and flags observations with large
model residuals as anomalies. Wraps ARIMA from the \code{forecast} package.
}
\details{
The detector estimates ARIMA(p,d,q) and computes standardized residuals.
Residual magnitudes are summarized via a distance function and thresholded
with outlier heuristics from \code{harutils()}.
}
\examples{
library(daltoolbox)

# Load anomaly example data
data(examples_anomalies)

# Use a simple example
dataset <- examples_anomalies$simple
head(dataset)

# Configure ARIMA anomaly detector
model <- hanr_arima()

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected anomalies
print(detection[(detection$event),])

}
\references{
\itemize{
\item Box GEP, Jenkins GM, Reinsel GC, Ljung GM (2015). Time Series Analysis: Forecasting
and Control. Wiley.
}
}
