% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.lambda_0.given.mu0.R
\name{find.lambda_0.given.mu0}
\alias{find.lambda_0.given.mu0}
\title{Function to solve for the baseline recurrent event rate given a target mean frequency for one-sample simulations.}
\usage{
find.lambda_0.given.mu0(lambda_star, gamma_shape, gamma_scale, t, mu0)
}
\arguments{
\item{lambda_star}{Rate parameter of an exponential distribution in generating the terminal event.}

\item{gamma_shape}{Shape parameter of the Gamma frailty distribution.}

\item{gamma_scale}{Scale parameter of the Gamma frailty distribution.}

\item{t}{Event time (time since enrollment) at which the mean frequency value \code{mu0} is defined.}

\item{mu0}{Target value of the mean frequency function at time \code{t}.}
}
\value{
A numeric value giving the baseline recurrent event rate \eqn{\lambda_0} that satisfies \eqn{\mu(t) = \mu(0)}.
}
\description{
Computes the value of the baseline recurrent event rate parameter.
}
\examples{
find.lambda_0.given.mu0(lambda_star = 0.1, gamma_shape = 2, gamma_scale = 0.5, t = 1, mu0 = 2)
}
