% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ci_resp}
\alias{ci_resp}
\title{Compute prediction and confidence intervals of smooth terms on response scale}
\usage{
ci_resp(
  model,
  newdata,
  nboot = 100,
  method = c("posterior", "delta_link", "delta_resp", "bootstrap_link", "bootstrap_resp"),
  level = 0.95
)
}
\arguments{
\item{model}{A fitted GAM object from \code{mgcv::gam}.}

\item{newdata}{A data.frame containing values at which to predict.}

\item{nboot}{Integer. Number of bootstrap or posterior samples. Default 1000.}

\item{method}{Character. One of \code{"delta_link"}, \code{"delta_resp"}, \code{"bootstrap_link"}, \code{"bootstrap_resp"}, \code{"posterior"}.}

\item{level}{Numeric. Confidence level, default 0.95.}
}
\value{
A \code{data.table} with columns: \code{fit}, \code{lwr}, \code{upr}.
}
\description{
This function computes predicted values and confidence intervals from a fitted GAM model
with a log-link (or other link) and optionally back-transforms predictions to the response scale.
Five methods are supported:
1. **delta_link**: classic delta method on the linear predictor (link) scale; back-transformed CI is asymmetric.
2. **delta_resp**: delta method applied directly on the response scale using
 \eqn{\mathrm{Var}[\exp(\eta)] \approx \exp(2\eta)\,\mathrm{Var}(\eta)}.
3. **bootstrap_link**: parametric bootstrap on the linear predictor; quantiles back-transformed.
4. **bootstrap_resp**: parametric bootstrap on the response scale; quantiles computed after exponentiating.
5. **posterior**: Bayesian posterior simulation using the model covariance matrix; quantiles on response scale.
}
\details{
References:
- Wood, S.N. (2017) *Generalized Additive Models: An Introduction with R, 2nd Edition*. CRC Press.
- Efron, B., & Tibshirani, R. (1993) *An Introduction to the Bootstrap*. Chapman & Hall.
- Gelman, A., et al. (2013) *Bayesian Data Analysis, 3rd Edition*. CRC Press.
}
\examples{
# loading processed data
dt.samples_trt <- readRDS(system.file("extdata", "dt.samples_trt.rds", package = "growthTrendR"))
# climate
dt.clim <- data.table::fread(system.file("extdata", "dt.clim.csv", package = "growthTrendR"))
# pre-data for model
dt.samples_clim <- prepare_samples_clim(dt.samples_trt, dt.clim)
dt.m <- dt.samples_clim[ageC >1]
# using gamm_spatial model as an example
m.sp <-gamm_spatial(data = dt.m, resp_scale = "resp_log",
       m.candidates = "bai_cm2 ~ log(ba_cm2_t_1) + s(ageC) + s(FFD)")

dt.m[, uid_site.fac:= as.factor(as.character(uid_site))]
dt.ci <- ci_resp(m.sp$model$gam, newdata = dt.m)

}
