% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grandR.R
\name{GetMatrix}
\alias{GetMatrix}
\title{Obtain a genes x values table as a large matrix}
\usage{
GetMatrix(
  data,
  mode.slot = DefaultSlot(data),
  columns = NULL,
  genes = Genes(data),
  count.as.integer = TRUE,
  name.by = "Symbol",
  summarize = NULL
)
}
\arguments{
\item{data}{A grandR object}

\item{mode.slot}{Which kind of data to access (see details)}

\item{columns}{which columns (i.e. samples or cells) to return (see details)}

\item{genes}{Restrict the output table to the given genes}

\item{count.as.integer}{Round to integers?}

\item{name.by}{A column name of \link{Coldata}(data). This is used as the rownames of the output table}

\item{summarize}{Should replicates by summarized? see details}
}
\value{
A (potentially) sparse matrix containing the desired values
}
\description{
This is the main function to access slot data for all genes as a (potentially sparse) matrix.
}
\details{
To refer to data slots, the mode.slot syntax can be used: It is either a data slot, or one of (new,old,total) followed by a dot followed by a slot. For new or old, the data slot value is multiplied by ntr or 1-ntr. This can be used e.g. to obtain the \emph{new counts}.

Columns can be given as a logical, integer or character vector representing a selection of the columns (samples or cells).
The expression is evaluated in an environment havin the \code{\link{Coldata}}, i.e. you can use names of \code{\link{Coldata}} as variables to
conveniently build a logical vector (e.g., columns=Condition=="x").

The summarization parameter can only be specified if columns is NULL. It is either a summarization matrix (\link{GetSummarizeMatrix}) or
TRUE (in which case \link{GetSummarizeMatrix}(data) is called). If there a NA values, they are imputed as the mean per group!
}
\seealso{
\link{GetData},\link{GetAnalysisTable},\link{DefaultSlot},\link{Genes},\link{GetSummarizeMatrix}
}
\concept{data}
