% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text-to-speech.R
\name{gl_talk}
\alias{gl_talk}
\title{Perform text to speech}
\usage{
gl_talk(
  input,
  output = "output.wav",
  languageCode = "en",
  gender = c("SSML_VOICE_GENDER_UNSPECIFIED", "MALE", "FEMALE", "NEUTRAL"),
  name = NULL,
  audioEncoding = c("LINEAR16", "MP3", "OGG_OPUS"),
  speakingRate = 1,
  pitch = 0,
  volumeGainDb = 0,
  sampleRateHertz = NULL,
  inputType = c("text", "ssml"),
  effectsProfileIds = NULL,
  forceLanguageCode = FALSE
)
}
\arguments{
\item{input}{The text to turn into speech}

\item{output}{Where to save the speech audio file}

\item{languageCode}{The language of the voice as a \code{BCP-47} language code}

\item{gender}{The gender of the voice, if available}

\item{name}{Name of the voice, see list via \link{gl_talk_languages} for supported voices.  Set to \code{NULL} to make the service choose a voice based on \code{languageCode} and \code{gender}.}

\item{audioEncoding}{Format of the requested audio stream}

\item{speakingRate}{Speaking rate/speed between \code{0.25} and \code{4.0}}

\item{pitch}{Speaking pitch between \code{-20.0} and \code{20.0} in semitones.}

\item{volumeGainDb}{Volumne gain in dB}

\item{sampleRateHertz}{Sample rate for returned audio}

\item{inputType}{Choose between \code{text} (the default) or SSML markup. The \code{input} text must be SSML markup if you choose \code{ssml}}

\item{effectsProfileIds}{Optional. An identifier which selects 'audio effects' profiles that are applied on (post synthesized) text to speech. Effects are applied on top of each other in the order they are given}

\item{forceLanguageCode}{If \code{name} is provided, this will ensure that the passed \code{languageCode} is used instead of being inferred from name. This is necessary for models that require the exact code (en-us, en-gb, ...), not just the two letters shorthand (en, es, ...)}
}
\value{
The file output name you supplied as \code{output}
}
\description{
Synthesizes speech synchronously: receive results after all text input has been processed.
}
\details{
Requires the Cloud Text-To-Speech API to be activated for your Google Cloud project.

Supported voices are here \url{https://cloud.google.com/text-to-speech/docs/voices} and can be imported into R via \link{gl_talk_languages}

To play the audio in code via a browser see \link{gl_talk_player}

To use Speech Synthesis Markup Language (SSML) select \code{inputType=ssml} - more details on using this to insert pauses, sounds and breaks in your audio can be found here: \url{https://cloud.google.com/text-to-speech/docs/ssml}

To use audio profiles, supply a character vector of the available audio profiles listed here: \url{https://cloud.google.com/text-to-speech/docs/audio-profiles} - the audio profiles are applied in the order given.  For instance \code{effectsProfileIds="wearable-class-device"} will optimise output for smart watches, \code{effectsProfileIds=c("wearable-class-device","telephony-class-application")} will apply sound filters optimised for smart watches, then telephonic devices.
}
\examples{

\dontrun{
library(magrittr)
gl_talk("The rain in spain falls mainly in the plain",
        output = "output.wav")

gl_talk("Testing my new audio player") \%>\% gl_talk_player()

# using SSML
gl_talk('<speak>The <say-as interpret-as=\"characters\">SSML</say-as>
  standard <break time=\"1s\"/>is defined by the
  <sub alias=\"World Wide Web Consortium\">W3C</sub>.</speak>',
  inputType =  "ssml")

# using effects profiles
gl_talk("This sounds great on headphones",
        effectsProfileIds = "headphone-class-device")

}

}
\seealso{
\url{https://cloud.google.com/text-to-speech/docs/}
}
