% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.fisherfit.R
\name{fortify.fisherfit}
\alias{fortify.fisherfit}
\alias{tidy.fisherfit}
\title{Tidied species rank abundance data and estimated Fisher's log-series}
\usage{
\method{fortify}{fisherfit}(model, data, ...)

\method{tidy}{fisherfit}(x, data, ...)
}
\arguments{
\item{model, x}{an object of class \code{\link[vegan:fisherfit]{vegan::fisherfit()}}).}

\item{data}{original data set. Currently ignored.}

\item{...}{other arguments pass to methods. Currently ignored.}
}
\value{
A data frame with columns \code{'Rank'} and \code{'Abundance'}. Additionally,
Fisher's \eqn{\alpha} and the nuisance parameter are returned as
attributes \code{'alpha'} and \code{'k'} respectively.
}
\description{
Prepares a data frame of results from a \code{\link[vegan:fisherfit]{vegan::fisherfit()}})
object suitable for plotting with \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}).
}
\examples{

library("vegan")

data(BCI)
mod <- fisherfit(BCI[5,])
head(fortify(mod))
}
\author{
Gavin L. Simpson
}
