% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.dbrda.R
\name{autoplot.dbrda}
\alias{autoplot.dbrda}
\title{ggplot-based plot for objects of class \code{"dbrda"}}
\usage{
\method{autoplot}{dbrda}(
  object,
  axes = c(1, 2),
  geom = c("point", "text"),
  layers = c("sites", "biplot", "centroids"),
  legend.position = "none",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  ylab = NULL,
  xlab = NULL,
  const = NULL,
  arrow.col = "navy",
  ...
)
}
\arguments{
\item{object}{an object of class \code{"dbrda"}, the result of a call to
\code{\link[vegan:dbrda]{vegan::dbrda()}}}

\item{axes}{numeric; which axes to plot, given as a vector of length 2.}

\item{geom}{character; which geom to use for the site (sample) scores. One
of \code{"point"}, or \code{"text"}.}

\item{layers}{character; which scores to plot as layers}

\item{legend.position}{character or two-element numeric vector; where to
position the legend. See \code{\link[ggplot2:theme]{ggplot2::theme()}} for details. Use \code{"none"}
to not draw the legend.}

\item{title}{character; subtitle for the plot.}

\item{subtitle}{character; subtitle for the plot.}

\item{caption}{character; caption for the plot.}

\item{ylab}{character; label for the y-axis.}

\item{xlab}{character; label for the x-axis.}

\item{const}{General scaling constant to \code{dbrda} scores. See
\code{\link[vegan:plot.cca]{vegan::scores.rda()}} for details.}

\item{arrow.col}{colour specification for biplot arrows and their labels.}

\item{...}{Additional arguments passed to the \code{\link[=fortify]{fortify()}} method.}
}
\value{
Returns a ggplot object.
}
\description{
Produces a multi-layer ggplot object representing the output of objects
produced by \code{\link[vegan:dbrda]{vegan::dbrda()}}.
}
\details{
TODO
}
\examples{

library("vegan")

data(dune, dune.env)

dune_dbrda <- dbrda(
  dune ~ A1 + Moisture + Use + Management,
  data = dune.env
)
autoplot(dune_dbrda)
}
\author{
Gavin L. Simpson
}
