% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinship2_alignped1.R
\name{kinship2_alignped1}
\alias{kinship2_alignped1}
\title{Align pedigree - Process a single subject and their spouses}
\usage{
kinship2_alignped1(x, dad, mom, level, horder, packed, spouselist)
}
\arguments{
\item{x}{Integer vector of subject ID(s) to process}

\item{dad}{Integer vector of father indices}

\item{mom}{Integer vector of mother indices}

\item{level}{Integer vector indicating the generation level of each subject}

\item{horder}{Numeric vector of hint order for positioning subjects}

\item{packed}{Logical, if TRUE uses compact packing algorithm}

\item{spouselist}{Matrix defining spouse relationships}
}
\value{
A list containing:
  \item{nid}{Matrix of subject IDs at each level and position}
  \item{pos}{Matrix of horizontal positions}
  \item{fam}{Matrix of family indices}
  \item{n}{Vector of counts per level}
  \item{spouselist}{Updated spouse list}
}
\description{
This is an internal helper function for pedigree alignment. It processes a single
subject (founder or not) along with their spouse(s), building up the alignment
structure. This function is called recursively by kinship2_align.pedigree to
construct the entire pedigree layout.
}
\keyword{internal}
