% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_rope_ext_back}
\alias{ggml_rope_ext_back}
\title{RoPE Extended Backward (Graph)}
\usage{
ggml_rope_ext_back(
  ctx,
  a,
  b,
  c = NULL,
  n_dims,
  mode = 0L,
  n_ctx_orig = 0L,
  freq_base = 10000,
  freq_scale = 1,
  ext_factor = 0,
  attn_factor = 1,
  beta_fast = 32,
  beta_slow = 1
)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Gradient tensor from upstream (gradients of ggml_rope_ext result)}

\item{b}{Position tensor (same as forward pass)}

\item{c}{Optional frequency factors tensor (NULL for default)}

\item{n_dims}{Number of dimensions for rotation}

\item{mode}{RoPE mode}

\item{n_ctx_orig}{Original context length}

\item{freq_base}{Base frequency}

\item{freq_scale}{Frequency scale factor}

\item{ext_factor}{Extension factor (YaRN)}

\item{attn_factor}{Attention factor}

\item{beta_fast}{YaRN fast beta}

\item{beta_slow}{YaRN slow beta}
}
\value{
Gradient tensor for the input
}
\description{
Backward pass for extended RoPE (Rotary Position Embedding).
Used during training to compute gradients through RoPE.
}
