% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_cpu_add}
\alias{ggml_cpu_add}
\title{Element-wise Addition (CPU Direct)}
\usage{
ggml_cpu_add(a, b)
}
\arguments{
\item{a}{First tensor (must be F32 type)}

\item{b}{Second tensor (must be F32 type, same size as a)}
}
\value{
Numeric vector containing the element-wise sum
}
\description{
Performs element-wise addition of two tensors using direct CPU computation.
Returns the result as an R numeric vector. Does NOT use computation graphs.
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
b <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(1, 2, 3, 4, 5))
ggml_set_f32(b, c(5, 4, 3, 2, 1))
ggml_cpu_add(a, b)
ggml_free(ctx)
}
}
