% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{ggml_are_same_layout}
\alias{ggml_are_same_layout}
\title{Check if Two Tensors Have the Same Layout}
\usage{
ggml_are_same_layout(a, b)
}
\arguments{
\item{a}{External pointer to first tensor}

\item{b}{External pointer to second tensor}
}
\value{
Logical indicating if tensors have identical layout
}
\description{
Compares two tensors to check if they have identical type, shape,
and strides. Tensors with the same layout can be used interchangeably
for memory operations.
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
a <- ggml_new_tensor_2d(ctx, GGML_TYPE_F32, 4, 4)
b <- ggml_new_tensor_2d(ctx, GGML_TYPE_F32, 4, 4)
same <- ggml_are_same_layout(a, b)  # TRUE
ggml_free(ctx)
}
}
\seealso{
Other tensor: 
\code{\link{ggml_get_op_params}()},
\code{\link{ggml_get_op_params_f32}()},
\code{\link{ggml_get_op_params_i32}()},
\code{\link{ggml_set_op_params}()},
\code{\link{ggml_set_op_params_f32}()},
\code{\link{ggml_set_op_params_i32}()}
}
\concept{tensor}
