% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggInterval_indexImage.R
\name{ggInterval_indexImage}
\alias{ggInterval_indexImage}
\title{An index plot presented by color image for interval data.}
\usage{
ggInterval_indexImage(data = NULL,mapping = aes(NULL),
column_condition=TRUE,full_strip=FALSE, plotAll = FALSE)
}
\arguments{
\item{data}{A ggInterval object. It can also be either RSDA object or
classical data frame,which will be automatically convert to ggInterval
data.}

\item{mapping}{Set of aesthetic mappings created by aes() or aes_().
If specified and inherit. aes = TRUE (the default),
it is combined with the default mapping at the top level of
the plot. You must supply mapping if there is no plot mapping.}

\item{column_condition}{Boolean variables, which mean the color
present by column condition (if TRUE) or matrix condition (if FALSE)}

\item{full_strip}{Boolean variables, which mean the strip present
in full figure-width (if TRUE) or only in its variable values(if FALSE).}

\item{plotAll}{Boolean, which determine if the heatmap type for visualizing
full variables is used. default FALSE.}
}
\value{
Return a ggplot2 object.
}
\description{
Visualize the range of the variables of each observations
by using color image.The index image replace margin bar by color,thus
it will be more visible for data.
}
\examples{
d<-data.frame(qq=rnorm(1000,0,1))
ggInterval_indexImage(d,aes(qq))

mydata<-ggInterval::facedata
p<-ggInterval_indexImage(mydata,aes(AD),full_strip=TRUE,column_condition = TRUE)
#Recommend to add coord_flip() to make the plot more visible
p+coord_flip()

myIris<-classic2sym(iris,groupby="Species")
myIris<-myIris$intervalData
p<-ggInterval_indexImage(myIris,aes(myIris$Petal.Length),full_strip=FALSE,column_condition=TRUE)
p

ggInterval_indexImage(mtcars,aes(disp))+labs(x="anything")

}
