% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryBand.R
\docType{class}
\name{ISOImageryBand}
\alias{ISOImageryBand}
\title{ISOImageryBand}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISO imagery band
}
\description{
ISOImageryBand

ISOImageryBand
}
\examples{
   #create band range dimension
   md <- ISOImageryBand$new()
   md$setSequenceIdentifier(ISOMemberName$new(aName = "name", attributeType = "type"))
   md$setDescriptor("descriptor")
   md$setMaxValue(10)
   md$setMinValue(1)
   gml <- GMLBaseUnit$new(id = "ID")
   gml$setDescriptionReference("someref")
   gml$setIdentifier("identifier", "codespace")
   gml$addName("name1", "codespace")
   gml$addName("name2", "codespace")
   gml$setQuantityTypeReference("someref")
   gml$setCatalogSymbol("symbol")
   gml$setUnitsSystem("somelink")
   md$setUnits(gml)
   md$setPeakResponse(9)
   md$setBitsPerValue(5)
   md$setToneGradation(100)
   md$setScaleFactor(1)
   md$setOffset(4)
   
   md$setBandBoundaryDefinition("fiftyPercent")
   md$setNominalSpatialResolution(14.5)
   md$setTransferFunctionType("linear")
   md$setTransmittedPolarisation("horizontal")
   md$setDetectedPolarisation("horizontal")
   
   xml <- md$encode()

}
\references{
- ISO 19139 \url{https://schemas.isotc211.org/19115/-2/gmi/1.0/gmi/#element_MI_Band}
  
  - ISO 19115-3 \url{https://schemas.isotc211.org/19115/-3/mrc/1.0/mrc/#element_MI_Band}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{band}
\keyword{imagery}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:ISORangeDimension]{geometa::ISORangeDimension}} -> \code{\link[geometa:ISOBand]{geometa::ISOBand}} -> \code{ISOImageryBand}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{bandBoundaryDefinition}}{bandBoundaryDefinition [0..1]: ISOImageryBandDefinition}

\item{\code{nominalSpatialResolution}}{nominalSpatialResolution [0..1] ISOBaseReal}

\item{\code{transferFunctionType}}{transferFunctionType [0..1]: ISOImageryTransferFunctionType}

\item{\code{transmittedPolarisation}}{transmittedPolarisation [0..1]: ISOImageryPolarisationOrientation}

\item{\code{detectedPolarisation}}{detectedPolarisation [0..1]: ISOImageryPolarisationOrientation}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOImageryBand-new}{\code{ISOImageryBand$new()}}
\item \href{#method-ISOImageryBand-setBandBoundaryDefinition}{\code{ISOImageryBand$setBandBoundaryDefinition()}}
\item \href{#method-ISOImageryBand-setNominalSpatialResolution}{\code{ISOImageryBand$setNominalSpatialResolution()}}
\item \href{#method-ISOImageryBand-setTransferFunctionType}{\code{ISOImageryBand$setTransferFunctionType()}}
\item \href{#method-ISOImageryBand-setTransmittedPolarisation}{\code{ISOImageryBand$setTransmittedPolarisation()}}
\item \href{#method-ISOImageryBand-setDetectedPolarisation}{\code{ISOImageryBand$setDetectedPolarisation()}}
\item \href{#method-ISOImageryBand-clone}{\code{ISOImageryBand$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISORangeDimension" data-id="setDescription"><a href='../../geometa/html/ISORangeDimension.html#method-ISORangeDimension-setDescription'><code>geometa::ISORangeDimension$setDescription()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISORangeDimension" data-id="setDescriptor"><a href='../../geometa/html/ISORangeDimension.html#method-ISORangeDimension-setDescriptor'><code>geometa::ISORangeDimension$setDescriptor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISORangeDimension" data-id="setName"><a href='../../geometa/html/ISORangeDimension.html#method-ISORangeDimension-setName'><code>geometa::ISORangeDimension$setName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISORangeDimension" data-id="setSequenceIdentifier"><a href='../../geometa/html/ISORangeDimension.html#method-ISORangeDimension-setSequenceIdentifier'><code>geometa::ISORangeDimension$setSequenceIdentifier()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOBand" data-id="setBitsPerValue"><a href='../../geometa/html/ISOBand.html#method-ISOBand-setBitsPerValue'><code>geometa::ISOBand$setBitsPerValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOBand" data-id="setMaxValue"><a href='../../geometa/html/ISOBand.html#method-ISOBand-setMaxValue'><code>geometa::ISOBand$setMaxValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOBand" data-id="setMinValue"><a href='../../geometa/html/ISOBand.html#method-ISOBand-setMinValue'><code>geometa::ISOBand$setMinValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOBand" data-id="setOffset"><a href='../../geometa/html/ISOBand.html#method-ISOBand-setOffset'><code>geometa::ISOBand$setOffset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOBand" data-id="setPeakResponse"><a href='../../geometa/html/ISOBand.html#method-ISOBand-setPeakResponse'><code>geometa::ISOBand$setPeakResponse()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOBand" data-id="setScaleFactor"><a href='../../geometa/html/ISOBand.html#method-ISOBand-setScaleFactor'><code>geometa::ISOBand$setScaleFactor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOBand" data-id="setToneGradation"><a href='../../geometa/html/ISOBand.html#method-ISOBand-setToneGradation'><code>geometa::ISOBand$setToneGradation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOBand" data-id="setUnits"><a href='../../geometa/html/ISOBand.html#method-ISOBand-setUnits'><code>geometa::ISOBand$setUnits()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryBand-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryBand-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryBand$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryBand-setBandBoundaryDefinition"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryBand-setBandBoundaryDefinition}{}}}
\subsection{Method \code{setBandBoundaryDefinition()}}{
Set band boundary definition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryBand$setBandBoundaryDefinition(definition)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{definition}}{object of class \link{ISOImageryBandDefinition} or \link{character}
among values returned by \code{ISOImageryBandDefinition$values()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryBand-setNominalSpatialResolution"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryBand-setNominalSpatialResolution}{}}}
\subsection{Method \code{setNominalSpatialResolution()}}{
Set nominal spatial resolution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryBand$setNominalSpatialResolution(resolution)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resolution}}{object of class \link{numeric}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryBand-setTransferFunctionType"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryBand-setTransferFunctionType}{}}}
\subsection{Method \code{setTransferFunctionType()}}{
Set transfer function type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryBand$setTransferFunctionType(functionType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{functionType}}{object of class \link{ISOImageryTransferFunctionType} or any \link{character}
from values returned by \code{ISOImageryTransferFunctionType$values()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryBand-setTransmittedPolarisation"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryBand-setTransmittedPolarisation}{}}}
\subsection{Method \code{setTransmittedPolarisation()}}{
Set transmitted polarisation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryBand$setTransmittedPolarisation(polarisation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{polarisation}}{object of class \link{ISOImageryPolarisationOrientation} or any \link{character}
from values returned by \code{ISOImageryPolarisationOrientation$values()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryBand-setDetectedPolarisation"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryBand-setDetectedPolarisation}{}}}
\subsection{Method \code{setDetectedPolarisation()}}{
Set detected polarisation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryBand$setDetectedPolarisation(polarisation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{polarisation}}{object of class \link{ISOImageryPolarisationOrientation} or any \link{character}
from values returned by \code{ISOImageryPolarisationOrientation$values()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryBand-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryBand-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryBand$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
