% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{plot_dependency_graph}
\alias{plot_dependency_graph}
\title{Analyze and plot R code dependencies in one step}
\usage{
plot_dependency_graph(
  file_paths,
  include_disconnected = TRUE,
  recursive = FALSE
)
}
\arguments{
\item{file_paths}{Character vector of R file paths, directory paths, or a mix.
The function automatically detects files vs directories.}

\item{include_disconnected}{Logical. If \code{FALSE}, exclude isolated nodes
(functions with no dependencies) from the graph. Default is \code{TRUE}.}

\item{recursive}{Logical. If directories are encountered, search subdirectories
recursively. Default is \code{FALSE}.}
}
\value{
A \code{visNetwork} HTML widget displaying the interactive dependency
graph. The graph can be saved using \code{htmlwidgets::saveWidget()}.
}
\description{
Convenience function that analyzes R files and directly returns the
interactive dependency graph without exposing intermediate analysis results.
Automatically detects whether paths are files or directories.
}
\details{
This is a convenience wrapper around \code{\link{analyze_internal_dependencies_multi}}
and \code{\link{plot_interactive_dependency_graph}}. It automatically:
\itemize{
\item Detects whether each path is a file or directory
\item Collects all R files from directories
\item Analyzes function dependencies
\item Creates an interactive visualization
}
}
\examples{
# Create temporary directory and files
temp_dir <- tempfile()
dir.create(temp_dir)

# Create sample R files
writeLines(c(
  "add <- function(a, b) { a + b }",
  "calc <- function(x) { add(x, 10) }"
), file.path(temp_dir, "math.R"))

writeLines(c(
  "process <- function(data) { add(data, 5) }"
), file.path(temp_dir, "process.R"))

# Analyze and plot - single file
graph <- plot_dependency_graph(file.path(temp_dir, "math.R"))

# Analyze directory
graph <- plot_dependency_graph(temp_dir)

# Exclude disconnected nodes
graph <- plot_dependency_graph(temp_dir, include_disconnected = FALSE)

# Clean up
unlink(temp_dir, recursive = TRUE)
}
