% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMFCC.R
\name{plot.AMFCC_PhaseI}
\alias{plot.AMFCC_PhaseI}
\alias{plot.AMFCC_PhaseII}
\title{Plot the results of the Phase I and the Phase II of the AMFCC}
\usage{
\method{plot}{AMFCC_PhaseI}(x, ...)

\method{plot}{AMFCC_PhaseII}(x, ...)
}
\arguments{
\item{x}{The output of  either \code{AMFCC_PhaseI} or \code{AMFCC_PhaseII}.}

\item{...}{Select the \code{type} of plot to produce either the contribution
plot 'cont' or the monitoring plot 'mon'. Default is 'mon'.
Select the \code{combining_function} to use for the monitoring
plot either 'Fisher' or 'Tippett'. Default is 'Fisher'.
Set the observation index \code{ind_obs} for which producing the
contribution plot.}
}
\value{
No return value, called for side effects.
}
\description{
This function provides plots of either the monitoring statistics
or the contribution plot for a given observation.
}
\examples{
\donttest{
library(funcharts)
N <- 10
l_grid <- 10
p <- 2
grid <- seq(0, 1, l = l_grid)


Xall_tra <- funcharts::simulate_mfd(
  nobs = N,
  p = p,
  ngrid = l_grid,
  correlation_type_x = c("Bessel", "Gaussian")
)
X_tra <-
  data.frame(
    x = c(Xall_tra$X_list[[1]], Xall_tra$X_list[[2]]),
    timeindex = rep(rep(1:l_grid, each = (N)), p),
    curve = rep(1:(N), l_grid * p),
    var = rep(1:p, each = l_grid * N)
  )

Xall_II <- funcharts::simulate_mfd(
  nobs = N,
  p = p,
  ngrid = l_grid,
  shift_type_x = list("A", "B"),
  d_x = c(10, 10),
  correlation_type_x = c("Bessel", "Gaussian")
)

X_II <-
  data.frame(
    x = c(Xall_II$X_list[[1]], Xall_II$X_list[[2]]),
    timeindex = rep(rep(1:l_grid, each = (N)), p),
    curve = rep(1:(N), l_grid * p),
    var = rep(1:p, each = l_grid * N)
  )

# AMFCC -------------------------------------------------------------------
print("AMFCC")

mod_phaseI_AMFCC <- AMFCC_PhaseI(
  data_tra = X_tra,
  data_tun =
    NULL,
  grid = grid,
  ncores = 1
)

mod_phaseII_AMFCC <- AMFCC_PhaseII(data = X_II,
mod_Phase_I = mod_phaseI_AMFCC,
ncores = 1)

plot(mod_phaseII_AMFCC)
plot(mod_phaseII_AMFCC,type='cont',ind_obs=1)
}

}
