% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stl.R
\name{generate.stl_decomposition}
\alias{generate.stl_decomposition}
\title{Generate block bootstrapped series from an STL decomposition}
\usage{
\method{generate}{stl_decomposition}(x, new_data, specials = NULL, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{new_data}{A tsibble containing the time points and exogenous regressors to produce forecasts for.}

\item{specials}{(passed by \code{\link[fabletools:forecast]{fabletools::forecast.mdl_df()}}).}

\item{...}{Other arguments passed to methods}
}
\description{
Produces new data with the same structure by resampling the residuals using
a block bootstrap procedure. This method can only generate within sample, and
any generated data out of the trained sample will produce NA simulations.
}
\examples{
as_tsibble(USAccDeaths) \%>\%
  model(STL(log(value))) \%>\%
  generate(as_tsibble(USAccDeaths), times = 3)

}
\references{
Bergmeir, C., R. J. Hyndman, and J. M. Benitez (2016). Bagging Exponential Smoothing Methods using STL Decomposition and Box-Cox Transformation. International Journal of Forecasting 32, 303-312.
}
