% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRR_RandomizationTest.R
\name{randomization_test}
\alias{randomization_test}
\title{Fast randomization test}
\usage{
randomization_test(
  obsW = NULL,
  obsY = NULL,
  alpha = 0.05,
  candidate_randomizations = NULL,
  candidate_randomizations_array = NULL,
  n0_array = NULL,
  n1_array = NULL,
  findFI = FALSE,
  c_initial = 2,
  conda_env = "fastrerandomize_env",
  conda_env_required = TRUE
)
}
\arguments{
\item{obsW}{A numeric vector where \code{0}'s correspond to control units and \code{1}'s to treated units.}

\item{obsY}{An optional numeric vector of observed outcomes. If not provided, the function assumes a NULL value.}

\item{alpha}{The significance level for the test. Default is \code{0.05}.}

\item{candidate_randomizations}{A numeric matrix of candidate randomizations.}

\item{candidate_randomizations_array}{An optional 'JAX' array of candidate randomizations. If not provided, the function coerces \code{candidate_randomizations} into a 'JAX' array.}

\item{n0_array}{An optional array specifying the number of control units.}

\item{n1_array}{An optional array specifying the number of treated units.}

\item{findFI}{A logical value indicating whether to find the fiducial interval. Default is FALSE.}

\item{c_initial}{A numeric value representing the initial criterion for the fiducial interval
search. Default is \code{2}.}

\item{conda_env}{A character string specifying the name of the conda environment to use
via \code{reticulate}. Default is \code{"fastrerandomize_env"}.}

\item{conda_env_required}{A logical indicating whether the specified conda environment
must be strictly used. If \code{TRUE}, an error is thrown if the environment is not found.
Default is \code{TRUE}.}
}
\value{
Returns an S3 object with slots: \itemize{
\item \code{p_value} A numeric value or vector representing the p-value of the test (or the expected p-value under the prior structure specified in the function inputs).
\item \code{FI} A numeric vector representing the fiducial interval if \code{findFI=TRUE}.
\item \code{tau_obs} A numeric value or vector representing the estimated treatment effect(s).
\item \code{fastrr_env} The fastrerandomize environment.
}
}
\description{
Fast randomization test
}
\section{References}{

\itemize{
\item Zhang, Y. and Zhao, Q., 2023. What is a randomization test?. Journal of the American Statistical Association, 118(544), pp.2928-2942.
}
}

\examples{
\dontrun{
# A small synthetic demonstration with 6 units, 3 treated and 3 controls:

# Generate pre-treatment covariates
X <- matrix(rnorm(24*2), ncol = 2)

# Generate candidate randomizations
RandomizationSet_MC <- generate_randomizations(
  n_units = nrow(X),
  n_treated = round(nrow(X)/2),
  X = X,
  randomization_accept_prob = 0.1,
  randomization_type = "monte_carlo",
  max_draws = 100000,
  batch_size = 1000
)

# Generate outcome
W <- RandomizationSet_MC$randomizations[1,]
obsY <- rnorm(nrow(X), mean = 2 * W)

# Perform randomization test
results_base <- randomization_test(
  obsW = W,
  obsY = obsY,
  candidate_randomizations = RandomizationSet_MC$randomizations
)
print(results_base)

# Perform randomization test with fiducial interval
result_fi <- randomization_test(
  obsW = W,
  obsY = obsY,
  candidate_randomizations = RandomizationSet_MC$randomizations,
  findFI = TRUE
)
print(result_fi)
}

}
\seealso{
\code{\link{generate_randomizations}} for randomization generation function.
}
